//GEMINI-pro DATASET v1.0 Category: Performance-Critical Component ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// A custom memory allocator that allocates memory from a pre-defined pool.
void *my_malloc(size_t size) {
    static char pool[1024];
    static char *ptr = pool;

    if (ptr + size > pool + sizeof(pool)) {
        return NULL;
    }

    void *p = ptr;
    ptr += size;
    return p;
}

// A custom memory deallocator that deallocates memory allocated by my_malloc.
void my_free(void *ptr) {
    // Do nothing, since the memory is allocated from a pre-defined pool.
}

// A performance-critical function that uses the custom memory allocator.
int perf_func() {
    // Allocate memory from the custom pool.
    char *buf = my_malloc(100);
    if (buf == NULL) {
        return -1;
    }

    // Perform some operations on the allocated memory.
    strcpy(buf, "Hello, world!");

    // Deallocate the memory.
    my_free(buf);

    return 0;
}

int main() {
    // Call the performance-critical function.
    int ret = perf_func();
    if (ret != 0) {
        printf("Error: perf_func() failed.\n");
        return -1;
    }

    printf("Success: perf_func() completed successfully.\n");
    return 0;
}