//Falcon2-11B DATASET v1.0 Category: Interprocess communication ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/wait.h>

#define MAX_MSG_LEN 1024

int main(int argc, char *argv[]) {
    int pipefd[2], status;
    char message[MAX_MSG_LEN];
    int pipe_write_status, pipe_read_status;
    pid_t child_pid;

    if (pipe(pipefd) == -1) {
        perror("pipe");
        exit(EXIT_FAILURE);
    }

    child_pid = fork();
    if (child_pid == -1) {
        perror("fork");
        exit(EXIT_FAILURE);
    } else if (child_pid == 0) { // child process
        close(pipefd[1]); // close read end of pipe
        pipe_write_status = write(pipefd[0], "Hello from child process!", strlen("Hello from child process!"));
        if (pipe_write_status == -1) {
            perror("write");
            exit(EXIT_FAILURE);
        }

        close(pipefd[0]); // close write end of pipe
        exit(0); // child process done, exit
    } else { // parent process
        close(pipefd[0]); // close write end of pipe
        pipe_read_status = read(pipefd[1], message, MAX_MSG_LEN);
        if (pipe_read_status == -1) {
            perror("read");
            exit(EXIT_FAILURE);
        }

        printf("Received message from child process: %s\n", message);

        wait(&status); // wait for child process to finish
        close(pipefd[1]); // close read end of pipe
    }

    return 0;
}