//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 100
#define MAX_FILE_NAME_LENGTH 50
#define MAX_FILE_SIZE 100

typedef struct {
    char name[MAX_FILE_NAME_LENGTH];
    int size;
    char content[MAX_FILE_SIZE];
} File;

int numFiles = 0;
File files[MAX_FILES];

void createFile(char *name, int size) {
    if (numFiles >= MAX_FILES) {
        printf("Error: Too many files.\n");
        return;
    }

    strcpy(files[numFiles].name, name);
    files[numFiles].size = size;

    printf("File '%s' created.\n", name);
    numFiles++;
}

void deleteFile(char *name) {
    int i;

    for (i = 0; i < numFiles; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("File '%s' deleted.\n", name);
            numFiles--;
            return;
        }
    }

    printf("File not found.\n");
}

void readFile(char *name) {
    int i;

    for (i = 0; i < numFiles; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("File '%s' content:\n%s\n", name, files[i].content);
            return;
        }
    }

    printf("File not found.\n");
}

void writeFile(char *name, char *content) {
    int i;

    for (i = 0; i < numFiles; i++) {
        if (strcmp(files[i].name, name) == 0) {
            strcpy(files[i].content, content);

            printf("File '%s' updated.\n", name);
            return;
        }
    }

    printf("File not found.\n");
}

int main() {
    createFile("test.txt", 10);
    writeFile("test.txt", "Hello, world!");
    readFile("test.txt");
    deleteFile("test.txt");

    return 0;
}