//GEMINI-pro DATASET v1.0 Category: Banking Record System ; Style: statistical
#include <stdio.h>
#include <stdlib.h>

// Define the maximum number of accounts
#define MAX_ACCOUNTS 100

// Define the account structure
typedef struct {
    int account_number;
    char *name;
    double balance;
} account_t;

// Create an array of accounts
account_t accounts[MAX_ACCOUNTS];

// Initialize the accounts
void init_accounts() {
    for (int i = 0; i < MAX_ACCOUNTS; i++) {
        accounts[i].account_number = 0;
        accounts[i].name = NULL;
        accounts[i].balance = 0.0;
    }
}

// Create a new account
int create_account(int account_number, char *name, double balance) {
    // Check if the account number is already in use
    for (int i = 0; i < MAX_ACCOUNTS; i++) {
        if (accounts[i].account_number == account_number) {
            return -1;
        }
    }

    // Create the new account
    int index = -1;
    for (int i = 0; i < MAX_ACCOUNTS; i++) {
        if (accounts[i].account_number == 0) {
            index = i;
            break;
        }
    }

    if (index == -1) {
        return -1;
    }

    accounts[index].account_number = account_number;
    accounts[index].name = name;
    accounts[index].balance = balance;

    return 0;
}

// Get the account balance
double get_balance(int account_number) {
    // Find the account
    int index = -1;
    for (int i = 0; i < MAX_ACCOUNTS; i++) {
        if (accounts[i].account_number == account_number) {
            index = i;
            break;
        }
    }

    if (index == -1) {
        return -1.0;
    }

    return accounts[index].balance;
}

// Deposit money into an account
int deposit_money(int account_number, double amount) {
    // Find the account
    int index = -1;
    for (int i = 0; i < MAX_ACCOUNTS; i++) {
        if (accounts[i].account_number == account_number) {
            index = i;
            break;
        }
    }

    if (index == -1) {
        return -1;
    }

    accounts[index].balance += amount;

    return 0;
}

// Withdraw money from an account
int withdraw_money(int account_number, double amount) {
    // Find the account
    int index = -1;
    for (int i = 0; i < MAX_ACCOUNTS; i++) {
        if (accounts[i].account_number == account_number) {
            index = i;
            break;
        }
    }

    if (index == -1) {
        return -1;
    }

    if (accounts[index].balance < amount) {
        return -1;
    }

    accounts[index].balance -= amount;

    return 0;
}

// Print the account information
void print_account(int account_number) {
    // Find the account
    int index = -1;
    for (int i = 0; i < MAX_ACCOUNTS; i++) {
        if (accounts[i].account_number == account_number) {
            index = i;
            break;
        }
    }

    if (index == -1) {
        return;
    }

    printf("Account number: %d\n", accounts[index].account_number);
    printf("Name: %s\n", accounts[index].name);
    printf("Balance: %.2f\n", accounts[index].balance);
}

// Main function
int main() {
    // Initialize the accounts
    init_accounts();

    // Create a new account
    create_account(123456, "John Doe", 1000.0);

    // Get the account balance
    double balance = get_balance(123456);

    // Deposit money into the account
    deposit_money(123456, 500.0);

    // Withdraw money from the account
    withdraw_money(123456, 300.0);

    // Print the account information
    print_account(123456);

    return 0;
}