//Gemma-7B DATASET v1.0 Category: Product Inventory System ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100

typedef struct Item {
  char name[50];
  int quantity;
  double price;
} Item;

Item items[MAX_ITEMS];

void addItem(char name, int quantity, double price) {
  int i = 0;
  for (; i < MAX_ITEMS && items[i].name[0] != '\0'; i++) {}
  items[i].name[0] = '\0';
  strcpy(items[i].name, name);
  items[i].quantity = quantity;
  items[i].price = price;
}

void updateQuantity(char name, int quantity) {
  int i = 0;
  for (; i < MAX_ITEMS && items[i].name[0] != '\0'; i++) {
    if (strcmp(items[i].name, name) == 0) {
      items[i].quantity = quantity;
      return;
    }
  }
  printf("Error: Item not found.\n");
}

void printInventory() {
  int i = 0;
  for (; i < MAX_ITEMS && items[i].name[0] != '\0'; i++) {
    printf("%s: %d, $%.2lf\n", items[i].name, items[i].quantity, items[i].price);
  }
}

int main() {
  addItem("Apple", 10, 1.20);
  addItem("Banana", 5, 0.80);
  addItem("Orange", 7, 1.50);
  printInventory();

  updateQuantity("Apple", 15);
  printInventory();

  return 0;
}