//Falcon2-11B DATASET v1.0 Category: System administration ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <sys/wait.h>

int main() {
    int child_pid, status;
    pid_t child_pid1, child_pid2;

    // Fork a child process
    child_pid = fork();
    if (child_pid < 0) {
        perror("Fork error");
        return 1;
    }
    if (child_pid > 0) {
        // Parent process
        printf("Child process PID: %d\n", getpid());
        printf("Parent process PID: %d\n", getpid());

        // Wait for the child process to exit
        wait(&status);

        // Exit the parent process
        printf("Child process exited with status: %d\n", WEXITSTATUS(status));
        return 0;
    }

    // Child process
    printf("Child process PID: %d\n", getpid());
    printf("Parent process PID: %d\n", getpid());

    // Create a second child process
    child_pid1 = fork();
    if (child_pid1 < 0) {
        perror("Fork error");
        return 1;
    }
    if (child_pid1 > 0) {
        // Parent process
        printf("Second child process PID: %d\n", getpid());
        printf("Parent process PID: %d\n", getpid());

        // Wait for the second child process to exit
        wait(&status);

        // Exit the parent process
        printf("Second child process exited with status: %d\n", WEXITSTATUS(status));
        return 0;
    }

    // Child process
    printf("Second child process PID: %d\n", getpid());
    printf("Parent process PID: %d\n", getpid());

    // Create a third child process
    child_pid2 = fork();
    if (child_pid2 < 0) {
        perror("Fork error");
        return 1;
    }
    if (child_pid2 > 0) {
        // Parent process
        printf("Third child process PID: %d\n", getpid());
        printf("Parent process PID: %d\n", getpid());

        // Wait for the third child process to exit
        wait(&status);

        // Exit the parent process
        printf("Third child process exited with status: %d\n", WEXITSTATUS(status));
        return 0;
    }

    // Child process
    printf("Third child process PID: %d\n", getpid());
    printf("Parent process PID: %d\n", getpid());

    // Exit the child process
    exit(0);
}