//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: shocked
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Weather conditions
#define SUNNY 0
#define CLOUDY 1
#define RAINY 2
#define STORMY 3

// Transition probabilities
#define SUNNY_TO_CLOUDY 0.2
#define SUNNY_TO_RAINY 0.1
#define SUNNY_TO_STORMY 0.05
#define CLOUDY_TO_SUNNY 0.3
#define CLOUDY_TO_RAINY 0.4
#define CLOUDY_TO_STORMY 0.2
#define RAINY_TO_SUNNY 0.2
#define RAINY_TO_CLOUDY 0.5
#define RAINY_TO_STORMY 0.3
#define STORMY_TO_SUNNY 0.1
#define STORMY_TO_CLOUDY 0.3
#define STORMY_TO_RAINY 0.6

// Initialize the weather
int weather = SUNNY;

// Simulate the weather for a given number of days
void simulate_weather(int days) {
  for (int i = 0; i < days; i++) {
    // Get a random number between 0 and 1
    float r = (float)rand() / (float)RAND_MAX;

    // Update the weather based on the transition probabilities
    switch (weather) {
    case SUNNY:
      if (r < SUNNY_TO_CLOUDY) {
        weather = CLOUDY;
      } else if (r < SUNNY_TO_RAINY) {
        weather = RAINY;
      } else if (r < SUNNY_TO_STORMY) {
        weather = STORMY;
      }
      break;
    case CLOUDY:
      if (r < CLOUDY_TO_SUNNY) {
        weather = SUNNY;
      } else if (r < CLOUDY_TO_RAINY) {
        weather = RAINY;
      } else if (r < CLOUDY_TO_STORMY) {
        weather = STORMY;
      }
      break;
    case RAINY:
      if (r < RAINY_TO_SUNNY) {
        weather = SUNNY;
      } else if (r < RAINY_TO_CLOUDY) {
        weather = CLOUDY;
      } else if (r < RAINY_TO_STORMY) {
        weather = STORMY;
      }
      break;
    case STORMY:
      if (r < STORMY_TO_SUNNY) {
        weather = SUNNY;
      } else if (r < STORMY_TO_CLOUDY) {
        weather = CLOUDY;
      } else if (r < STORMY_TO_RAINY) {
        weather = RAINY;
      }
      break;
    }

    // Print the weather forecast
    switch (weather) {
    case SUNNY:
      printf("Sunny");
      break;
    case CLOUDY:
      printf("Cloudy");
      break;
    case RAINY:
      printf("Rainy");
      break;
    case STORMY:
      printf("Stormy");
      break;
    }

    printf("\n");
  }
}

int main() {
  // Seed the random number generator
  srand(time(NULL));

  // Simulate the weather for 10 days
  simulate_weather(10);

  return 0;
}