//Falcon-180B DATASET v1.0 Category: Secure Password Generator ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <ctype.h>

#define PASSWORD_LENGTH 16
#define CHARACTER_SET_LENGTH 82

char character_set[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>/?";

void generate_password(char *password) {
    int i;
    for (i = 0; i < PASSWORD_LENGTH; i++) {
        password[i] = character_set[rand() % CHARACTER_SET_LENGTH];
    }
    password[PASSWORD_LENGTH] = '\0';
}

int main() {
    char password[PASSWORD_LENGTH + 1];
    int password_strength;
    char *password_strength_str;

    srand(time(NULL));
    generate_password(password);

    printf("Generated password: %s\n", password);

    password_strength = check_password_strength(password);
    switch (password_strength) {
        case 1:
            password_strength_str = "Very Weak";
            break;
        case 2:
            password_strength_str = "Weak";
            break;
        case 3:
            password_strength_str = "Good";
            break;
        case 4:
            password_strength_str = "Strong";
            break;
        case 5:
            password_strength_str = "Very Strong";
            break;
    }

    printf("Password strength: %s\n", password_strength_str);

    return 0;
}

int check_password_strength(char *password) {
    int length = strlen(password);
    int has_uppercase = 0;
    int has_lowercase = 0;
    int has_number = 0;
    int has_special_char = 0;

    if (length < 8) {
        return 1;
    }

    while (*password) {
        if (isupper(*password)) {
            has_uppercase = 1;
        } else if (islower(*password)) {
            has_lowercase = 1;
        } else if (isdigit(*password)) {
            has_number = 1;
        } else if (!isalnum(*password)) {
            has_special_char = 1;
        }
        password++;
    }

    if (has_uppercase && has_lowercase && has_number && has_special_char) {
        return 5;
    } else if (has_uppercase && has_lowercase && has_number) {
        return 4;
    } else if (has_uppercase && has_lowercase && has_special_char) {
        return 3;
    } else if (has_uppercase && has_number && has_special_char) {
        return 3;
    } else if (has_lowercase && has_number && has_special_char) {
        return 3;
    } else if (has_uppercase && has_lowercase) {
        return 2;
    } else if (has_uppercase || has_lowercase) {
        return 2;
    } else {
        return 1;
    }
}