//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of products in the inventory
#define MAX_PRODUCTS 100

// Define the structure of a product
typedef struct product {
    int id;
    char name[50];
    int quantity;
    float price;
} product;

// Define the array of products
product inventory[MAX_PRODUCTS];

// Define the number of products in the inventory
int num_products = 0;

// Function to add a product to the inventory
void add_product(product p) {
    // Check if the inventory is full
    if (num_products >= MAX_PRODUCTS) {
        printf("Error: Inventory is full!\n");
        return;
    }

    // Add the product to the inventory
    inventory[num_products] = p;
    num_products++;
}

// Function to remove a product from the inventory
void remove_product(int id) {
    // Find the product in the inventory
    int i;
    for (i = 0; i < num_products; i++) {
        if (inventory[i].id == id) {
            break;
        }
    }

    // Check if the product was found
    if (i == num_products) {
        printf("Error: Product not found!\n");
        return;
    }

    // Remove the product from the inventory
    for (i; i < num_products - 1; i++) {
        inventory[i] = inventory[i + 1];
    }
    num_products--;
}

// Function to update a product in the inventory
void update_product(product p) {
    // Find the product in the inventory
    int i;
    for (i = 0; i < num_products; i++) {
        if (inventory[i].id == p.id) {
            break;
        }
    }

    // Check if the product was found
    if (i == num_products) {
        printf("Error: Product not found!\n");
        return;
    }

    // Update the product in the inventory
    inventory[i] = p;
}

// Function to print the inventory
void print_inventory() {
    // Print the header
    printf("ID\tName\t\tQuantity\tPrice\n");

    // Print the products
    int i;
    for (i = 0; i < num_products; i++) {
        printf("%d\t%s\t\t%d\t%f\n", inventory[i].id, inventory[i].name, inventory[i].quantity, inventory[i].price);
    }
}

// Function to search for a product in the inventory
product* search_product(int id) {
    // Find the product in the inventory
    int i;
    for (i = 0; i < num_products; i++) {
        if (inventory[i].id == id) {
            return &inventory[i];
        }
    }

    // Return NULL if the product was not found
    return NULL;
}

// Main function
int main() {
    // Add some products to the inventory
    add_product((product) {1, "Apple", 10, 1.0});
    add_product((product) {2, "Orange", 20, 2.0});
    add_product((product) {3, "Banana", 30, 3.0});

    // Print the inventory
    printf("Initial inventory:\n");
    print_inventory();

    // Remove a product from the inventory
    remove_product(2);

    // Print the inventory
    printf("Inventory after removing product 2:\n");
    print_inventory();

    // Update a product in the inventory
    update_product((product) {1, "Apple", 20, 1.5});

    // Print the inventory
    printf("Inventory after updating product 1:\n");
    print_inventory();

    // Search for a product in the inventory
    product* p = search_product(3);
    if (p != NULL) {
        printf("Product found: %d, %s, %d, %f\n", p->id, p->name, p->quantity, p->price);
    } else {
        printf("Product not found!\n");
    }

    return 0;
}