//GPT-4o-mini DATASET v1.0 Category: Digital Watermarking ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

#define WIDTH 5
#define HEIGHT 5

// Function to display the image matrix
void displayImage(uint8_t image[HEIGHT][WIDTH]) {
    printf("\nImage Matrix:\n");
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            printf("%3d ", image[i][j]);
        }
        printf("\n");
    }
}

// Function to embed a watermark into the image
void embedWatermark(uint8_t image[HEIGHT][WIDTH], uint8_t watermark[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            if (watermark[i][j] > 0) {
                image[i][j] = (image[i][j] + 1) % 256; // Alter the pixel
            }
        }
    }
}

// Function to extract the watermark from the image
void extractWatermark(uint8_t image[HEIGHT][WIDTH], uint8_t watermark[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            if (image[i][j] % 2 == 1) { // Check if the pixel was altered
                watermark[i][j] = 255; // Mark the watermark location
            } else {
                watermark[i][j] = 0; // No watermark here
            }
        }
    }
}

int main() {
    // Initialize a sample image
    uint8_t image[HEIGHT][WIDTH] = {
        { 10, 20, 30, 40, 50 },
        { 60, 70, 80, 90, 100 },
        { 110, 120, 130, 140, 150 },
        { 160, 170, 180, 190, 200 },
        { 210, 220, 230, 240, 250 }
    };

    // Initialize a watermark
    uint8_t watermark[HEIGHT][WIDTH] = {
        { 0, 0, 1, 0, 0 },
        { 0, 0, 0, 0, 1 },
        { 1, 0, 0, 1, 0 },
        { 0, 1, 0, 0, 0 },
        { 0, 0, 1, 0, 0 }
    };

    // Display the original image
    displayImage(image);

    // Display the watermark
    printf("\nWatermark Matrix:\n");
    displayImage(watermark);

    // Embed the watermark into the image
    embedWatermark(image, watermark);

    // Display the altered image with the embedded watermark
    printf("\nImage after embedding watermark:\n");
    displayImage(image);

    // Prepare to extract the watermark
    uint8_t extractedWatermark[HEIGHT][WIDTH] = {0};

    // Extract the watermark from the image
    extractWatermark(image, extractedWatermark);

    // Display the extracted watermark
    printf("\nExtracted Watermark Matrix:\n");
    displayImage(extractedWatermark);

    return 0;
}