//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_DAYS 10
#define TEMP_MIN 15
#define TEMP_MAX 30

typedef struct Weather {
    int temperature;
    int rain; // 1 for rain, 0 for no rain
} Weather;

// Function prototypes
Weather generateWeather(Weather previousWeather, int day);
void printWeather(Weather weather, int day);
void simulateWeather(int currentDay, Weather previousWeather);

int main() {
    srand(time(NULL)); // Seed the random number generator
    Weather initialWeather = {TEMP_MIN + rand() % (TEMP_MAX - TEMP_MIN + 1), 0};

    printf("Weather Simulation for %d Days\n", MAX_DAYS);
    printf("Day | Temperature | Rain\n");
    printf("--------------------------\n");
    
    simulateWeather(1, initialWeather);

    return 0;
}

// Recursive function to simulate weather for each day
void simulateWeather(int currentDay, Weather previousWeather) {
    // Base case: Stop when the maximum number of days is reached
    if (currentDay > MAX_DAYS) {
        return;
    }

    // Generate today's weather based on yesterday's weather
    Weather todayWeather = generateWeather(previousWeather, currentDay);
    
    // Print today's weather
    printWeather(todayWeather, currentDay);
    
    // Recursive call to simulate the next day's weather
    simulateWeather(currentDay + 1, todayWeather);
}

// Function to generate the weather for the current day
Weather generateWeather(Weather previousWeather, int day) {
    Weather newWeather;

    // Adjust temperature based on previous day's weather
    newWeather.temperature = previousWeather.temperature + (rand() % 5 - 2); // Randomly +/- 2 degrees
    if (newWeather.temperature < TEMP_MIN) newWeather.temperature = TEMP_MIN; // Ensure min temperature
    if (newWeather.temperature > TEMP_MAX) newWeather.temperature = TEMP_MAX; // Ensure max temperature

    // Determine if it will rain
    newWeather.rain = (rand() % 100 < ((previousWeather.rain == 1) ? 60 : 20)) ? 1 : 0; // Higher chance if it rained yesterday

    return newWeather;
}

// Function to print today's weather
void printWeather(Weather weather, int day) {
    printf("%3d | %12d | %4s\n", day, weather.temperature, weather.rain ? "Yes" : " No");
}