//GEMINI-pro DATASET v1.0 Category: Building a HTTP Client ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <pthread.h>

int main() {
    // Initialize the client socket.
    int client_socket = socket(AF_INET, SOCK_STREAM, 0);
    if (client_socket == -1) {
        perror("Error creating client socket");
        return EXIT_FAILURE;
    }

    // Set up the server address.
    struct sockaddr_in server_address;
    memset(&server_address, 0, sizeof(server_address));
    server_address.sin_family = AF_INET;
    server_address.sin_port = htons(80);
    if (inet_pton(AF_INET, "127.0.0.1", &server_address.sin_addr) <= 0) {
        perror("Error converting IP address");
        return EXIT_FAILURE;
    }

    // Connect to the server.
    if (connect(client_socket, (struct sockaddr *)&server_address, sizeof(server_address)) == -1) {
        perror("Error connecting to server");
        return EXIT_FAILURE;
    }

    // Send an HTTP request to the server.
    char *request = "GET / HTTP/1.1\r\nHost: 127.0.0.1\r\n\r\n";
    if (send(client_socket, request, strlen(request), 0) == -1) {
        perror("Error sending request");
        return EXIT_FAILURE;
    }

    // Receive the HTTP response from the server.
    char response[4096];
    memset(response, 0, sizeof(response));
    if (recv(client_socket, response, sizeof(response), 0) == -1) {
        perror("Error receiving response");
        return EXIT_FAILURE;
    }

    // Parse the HTTP response.
    char *status_line = strtok(response, "\r\n");
    if (status_line == NULL) {
        perror("Error parsing status line");
        return EXIT_FAILURE;
    }

    // Print the status line.
    printf("%s\n", status_line);

    // Close the client socket.
    if (close(client_socket) == -1) {
        perror("Error closing client socket");
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}