//Gemma-7B DATASET v1.0 Category: Hexadecimal Converter ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct Hexadecimal_Converter {
    char input[1024];
    int input_length;
    char output[1024];
    int output_length;
    int converted_length;
    int is_valid;
} Hexadecimal_Converter;

void convert_hexadecimal(Hexadecimal_Converter *converter) {
    int i = 0;
    converter->converted_length = 0;
    for (i = 0; i < converter->input_length; i++) {
        char digit = converter->input[i];
        int number = 0;
        if (digit >= 'a' && digit <= 'f') {
            number = digit - 'a' + 10;
        } else if (digit >= 'A' && digit <= 'F') {
            number = digit - 'A' + 10;
        } else if (digit >= '0' && digit <= '9') {
            number = digit - '0';
        } else {
            converter->is_valid = 0;
            return;
        }
        int multiple = 1;
        for (int j = converter->converted_length; j >= 0; j--) {
            multiple *= 16;
            converter->output[j] = (number / multiple) % 16 + '0';
            number %= multiple;
        }
        converter->converted_length++;
    }
}

int main() {
    Hexadecimal_Converter converter;
    converter.input_length = 0;
    converter.output_length = 0;
    converter.is_valid = 1;

    printf("Enter hexadecimal input: ");
    getline(converter.input, 1024, stdin);

    convert_hexadecimal(&converter);

    if (converter.is_valid) {
        printf("Converted hexadecimal output: ");
        for (int i = 0; i < converter.converted_length; i++) {
            printf("%c ", converter.output[i]);
        }
        printf("\n");
    } else {
        printf("Invalid input.\n");
    }

    return 0;
}