//MISTRAL-7B DATASET v1.0 Category: Pattern printing ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

#define MAX 10
#define WIDTH ((MAX * 2) + 1)

void print_spiral(int matrix[MAX][MAX]) {
    int top = 0, bottom = MAX - 1, left = 0, right = MAX - 1;
    int dir = 0;

    while (top <= bottom && left <= right) {
        for (int i = left; i <= right; i++) {
            printf("%d ", matrix[top][i]);
        }
        top++;

        for (int i = top; i <= bottom; i++) {
            if (dir == 0) {
                if (left > i) {
                    printf("   ");
                    continue;
                }
            }
            printf("%d ", matrix[i][right]);
        }
        right--;

        for (int i = right; i >= left; i--) {
            if (dir == 1) {
                if (top > i) {
                    printf("   ");
                    continue;
                }
            }
            printf("%d ", matrix[bottom][i]);
        }
        bottom--;

        for (int i = bottom; i >= top; i--) {
            if (dir == 2) {
                if (right < i) {
                    printf("   ");
                    continue;
                }
            }
            printf("%d ", matrix[i][left]);
        }
        left++;

        if (top > bottom || left > right) {
            break;
        }

        dir = (dir + 1) % 4;
    }

    printf("\n");
}

void generate_matrix(int matrix[MAX][MAX]) {
    srand(time(NULL));

    for (int i = 0; i < MAX; i++) {
        for (int j = 0; j < MAX; j++) {
            matrix[i][j] = rand() % 101;
        }
    }
}

int main() {
    int matrix[MAX][MAX];

    generate_matrix(matrix);

    printf("Matrix:\n");

    for (int i = 0; i < MAX; i++) {
        for (int j = 0; j < MAX; j++) {
            printf("%d ", matrix[i][j]);
        }
        printf("\n");
    }

    printf("Spiral:\n");

    print_spiral(matrix);

    return 0;
}