//GEMINI-pro DATASET v1.0 Category: Maze Route Finder ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAZE_WIDTH 10
#define MAZE_HEIGHT 10
#define MAZE_START_X 0
#define MAZE_START_Y 0
#define MAZE_END_X (MAZE_WIDTH - 1)
#define MAZE_END_Y (MAZE_HEIGHT - 1)
#define MAZE_WALL '#'
#define MAZE_SPACE ' '

typedef struct {
    int x;
    int y;
} point_t;

// Create a maze
char maze[MAZE_HEIGHT][MAZE_WIDTH];

// Create a stack of points
point_t stack[MAZE_WIDTH * MAZE_HEIGHT];
int stack_top = 0;

// Create a function to push a point onto the stack
void push(point_t point) {
    stack[stack_top++] = point;
}

// Create a function to pop a point off the stack
point_t pop() {
    return stack[--stack_top];
}

// Create a function to check if a point is valid
int is_valid(point_t point) {
    return point.x >= 0 && point.x < MAZE_WIDTH && point.y >= 0 && point.y < MAZE_HEIGHT && maze[point.y][point.x] != MAZE_WALL;
}

// Create a function to find a path through the maze
int find_path() {
    // Start at the start of the maze
    point_t current_point = {MAZE_START_X, MAZE_START_Y};
    push(current_point);

    // While the stack is not empty
    while (stack_top > 0) {
        // Pop the current point off the stack
        current_point = pop();

        // Check if the current point is the end of the maze
        if (current_point.x == MAZE_END_X && current_point.y == MAZE_END_Y) {
            return 1;
        }

        // Check if the current point is valid
        if (!is_valid(current_point)) {
            continue;
        }

        // Mark the current point as visited
        maze[current_point.y][current_point.x] = MAZE_SPACE;

        // Push the neighbors of the current point onto the stack
        point_t neighbors[4];
        neighbors[0] = (point_t){current_point.x - 1, current_point.y};
        neighbors[1] = (point_t){current_point.x + 1, current_point.y};
        neighbors[2] = (point_t){current_point.x, current_point.y - 1};
        neighbors[3] = (point_t){current_point.x, current_point.y + 1};
        for (int i = 0; i < 4; i++) {
            if (is_valid(neighbors[i])) {
                push(neighbors[i]);
            }
        }
    }

    // No path was found
    return 0;
}

// Create a function to print the maze
void print_maze() {
    for (int y = 0; y < MAZE_HEIGHT; y++) {
        for (int x = 0; x < MAZE_WIDTH; x++) {
            printf("%c", maze[y][x]);
        }
        printf("\n");
    }
}

int main() {
    // Initialize the maze
    for (int y = 0; y < MAZE_HEIGHT; y++) {
        for (int x = 0; x < MAZE_WIDTH; x++) {
            maze[y][x] = MAZE_WALL;
        }
    }

    // Create a path through the maze
    if (find_path()) {
        printf("Path found:\n");
        print_maze();
    } else {
        printf("No path found.\n");
    }
    return 0;
}