//Falcon-180B DATASET v1.0 Category: Math exercise ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX_SIZE 100

typedef struct {
    int id;
    char name[20];
    float grade;
} Student;

void add_student(Student* students, int size, int id, char* name, float grade) {
    if (size >= MAX_SIZE) {
        printf("Error: Maximum number of students reached.\n");
        return;
    }

    students[size].id = id;
    strcpy(students[size].name, name);
    students[size].grade = grade;

    size++;
}

void print_students(Student* students, int size) {
    printf("Student ID\tName\tGrade\n");
    for (int i = 0; i < size; i++) {
        printf("%d\t%s\t%.2f\n", students[i].id, students[i].name, students[i].grade);
    }
}

void calculate_average(Student* students, int size) {
    float sum = 0.0;

    for (int i = 0; i < size; i++) {
        sum += students[i].grade;
    }

    printf("Average Grade: %.2f\n", sum / size);
}

int main() {
    Student students[MAX_SIZE];
    int size = 0;

    add_student(students, size, 1, "John Doe", 85.5);
    add_student(students, size, 2, "Jane Smith", 90.0);
    add_student(students, size, 3, "Bob Johnson", 78.5);

    print_students(students, size);
    calculate_average(students, size);

    return 0;
}