//Falcon-180B DATASET v1.0 Category: Threading Library Implementation ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

// Define the data structure to be shared among threads
typedef struct {
    int count;
    pthread_mutex_t mutex;
} shared_data_t;

// Function to be executed by each thread
void *thread_func(void *arg) {
    shared_data_t *data = (shared_data_t *) arg;

    // Lock the mutex before accessing shared data
    pthread_mutex_lock(&data->mutex);

    // Increment the count and print the current value
    data->count++;
    printf("Thread %lu: count = %d\n", pthread_self(), data->count);

    // Unlock the mutex after accessing shared data
    pthread_mutex_unlock(&data->mutex);

    return NULL;
}

int main() {
    int num_threads = 5;
    pthread_t threads[num_threads];
    shared_data_t data;

    // Initialize the shared data
    data.count = 0;
    pthread_mutex_init(&data.mutex, NULL);

    // Create the threads
    for (int i = 0; i < num_threads; i++) {
        pthread_create(&threads[i], NULL, thread_func, &data);
    }

    // Join the threads
    for (int i = 0; i < num_threads; i++) {
        pthread_join(threads[i], NULL);
    }

    // Destroy the mutex
    pthread_mutex_destroy(&data.mutex);

    return 0;
}