//GPT-4o-mini DATASET v1.0 Category: Remote control Vehicle Simulation ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <unistd.h>

#define MAX_VEHICLES 10
#define MAX_NAME_LENGTH 20

typedef struct {
    char name[MAX_NAME_LENGTH];
    float speed; // Speed in meters per second
    float distance; // Distance traveled in meters
    bool is_moving;
} Vehicle;

void initialize_vehicle(Vehicle* vehicle, const char* name, float speed) {
    strncpy(vehicle->name, name, MAX_NAME_LENGTH);
    vehicle->speed = speed;
    vehicle->distance = 0.0;
    vehicle->is_moving = false;
}

void start_vehicle(Vehicle* vehicle) {
    if (!vehicle->is_moving) {
        vehicle->is_moving = true;
        printf("%s started moving at speed %.2f m/s.\n", vehicle->name, vehicle->speed);
    } else {
        printf("%s is already moving.\n", vehicle->name);
    }
}

void stop_vehicle(Vehicle* vehicle) {
    if (vehicle->is_moving) {
        vehicle->is_moving = false;
        printf("%s stopped after traveling %.2f meters.\n", vehicle->name, vehicle->distance);
    } else {
        printf("%s is already stopped.\n", vehicle->name);
    }
}

void update_vehicle_distance(Vehicle* vehicle, float time_interval) {
    if (vehicle->is_moving) {
        vehicle->distance += vehicle->speed * time_interval;
        printf("%s has traveled %.2f meters.\n", vehicle->name, vehicle->distance);
    }
}

void print_vehicle_status(const Vehicle* vehicle) {
    printf("Vehicle: %s | Speed: %.2f m/s | Distance: %.2f m | Status: %s\n", 
           vehicle->name, vehicle->speed, vehicle->distance, 
           vehicle->is_moving ? "Moving" : "Stopped");
}

void simulate_vehicle(Vehicle* vehicle) {
    for (int i = 0; i < 5; i++) {
        start_vehicle(vehicle);
        update_vehicle_distance(vehicle, 1.0); // 1 second simulation
        sleep(1);
    }
    stop_vehicle(vehicle);
}

int main() {
    Vehicle vehicles[MAX_VEHICLES];
    int vehicle_count = 0;

    printf("Welcome to the Remote Control Vehicle Simulation!\n");

    // Initialize vehicles
    initialize_vehicle(&vehicles[vehicle_count++], "Car", 3.0);
    initialize_vehicle(&vehicles[vehicle_count++], "Truck", 2.0);
    initialize_vehicle(&vehicles[vehicle_count++], "Bike", 4.0);
    initialize_vehicle(&vehicles[vehicle_count++], "Robot", 1.5);
    
    // Simulate each vehicle
    for (int i = 0; i < vehicle_count; i++) {
        printf("\nSimulating %s...\n", vehicles[i].name);
        simulate_vehicle(&vehicles[i]);
        print_vehicle_status(&vehicles[i]);
    }

    printf("\nSimulation completed. All vehicles are stopped.\n");
    return 0;
}