//Falcon-180B DATASET v1.0 Category: Network Packet Monitoring ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>
#include <arpa/inet.h>

#define MAX_DATA_SIZE 65536
#define MAX_PACKETS 1000

typedef struct {
    char *data;
    int size;
} PacketData;

PacketData packets[MAX_PACKETS];
int packet_count = 0;

void process_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    char *data = (char *) packet;
    int size = header->len;

    if (packet_count == MAX_PACKETS) {
        printf("Maximum packet count reached.\n");
        return;
    }

    packets[packet_count].data = malloc(size + 1);
    memcpy(packets[packet_count].data, data, size);
    packets[packet_count].size = size;
    packet_count++;
}

void print_packets() {
    for (int i = 0; i < packet_count; i++) {
        printf("Packet %d:\n", i);
        printf("Data: %s\n", packets[i].data);
        printf("Size: %d\n\n", packets[i].size);
    }
}

int main() {
    char *dev = "eth0";
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    int res;

    handle = pcap_open_live(dev, BUFSIZ, 1, 0, errbuf);

    if (handle == NULL) {
        printf("Error opening capture device: %s\n", errbuf);
        exit(1);
    }

    res = pcap_loop(handle, -1, process_packet, NULL);

    if (res == -1) {
        printf("Error in pcap_loop: %s\n", pcap_geterr(handle));
        exit(1);
    }

    print_packets();

    pcap_close(handle);
    return 0;
}