//LLAMA2-13B DATASET v1.0 Category: Encryption ; Style: protected
#include <stdio.h>
#include <string.h>
#include <stdint.h>
#include <stdbool.h>

#define KEY_SIZE 16
#define BLOCK_SIZE 16

typedef struct {
    uint8_t key[KEY_SIZE];
    uint8_t block[BLOCK_SIZE];
    size_t index;
} encryption_ctx_t;

void encryption_init(encryption_ctx_t *ctx, const uint8_t *key) {
    memset(ctx, 0, sizeof(encryption_ctx_t));
    memcpy(ctx->key, key, KEY_SIZE);
}

void encryption_process(encryption_ctx_t *ctx, const uint8_t *data, size_t size) {
    size_t i;
    for (i = 0; i < size; i++) {
        uint8_t temp = data[i] ^ ctx->key[ctx->index];
        ctx->block[ctx->index] = temp;
        ctx->index = (ctx->index + 1) % KEY_SIZE;
    }
}

void encryption_finalize(encryption_ctx_t *ctx) {
    uint8_t final_block[BLOCK_SIZE];
    size_t final_size = ctx->index % BLOCK_SIZE;
    memcpy(final_block, ctx->block, final_size);
    printf("Encrypted message: ");
    for (size_t i = 0; i < final_size; i++) {
        printf("%02x", final_block[i]);
    }
    printf("\n");
}

int main() {
    encryption_ctx_t ctx;
    const uint8_t key[] = "This is a secret key";
    uint8_t message[] = "Hello, world!";
    size_t message_size = strlen(message);

    encryption_init(&ctx, key);
    encryption_process(&ctx, message, message_size);
    encryption_finalize(&ctx);

    return 0;
}