//Falcon-180B DATASET v1.0 Category: Queue Implementation ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>

#define MAX_SIZE 100 // maximum size of the queue

// structure for the queue
struct Queue {
    int data[MAX_SIZE]; // data to be stored
    int front; // front of the queue
    int rear; // rear of the queue
};

// function for creating an empty queue
void createQueue(struct Queue* q) {
    q->front = -1; // initialize front to -1
    q->rear = -1; // initialize rear to -1
}

// function for checking if the queue is empty
int isEmpty(struct Queue* q) {
    if (q->front == -1 && q->rear == -1) {
        return 1; // queue is empty
    } else {
        return 0; // queue is not empty
    }
}

// function for checking if the queue is full
int isFull(struct Queue* q) {
    if ((q->rear + 1) % MAX_SIZE == q->front) {
        return 1; // queue is full
    } else {
        return 0; // queue is not full
    }
}

// function for inserting an element into the queue
void enqueue(struct Queue* q, int value) {
    if (isFull(q)) {
        printf("Queue is full!\n");
    } else {
        if (isEmpty(q)) {
            q->front = 0;
            q->rear = 0;
        } else {
            q->rear = (q->rear + 1) % MAX_SIZE;
        }
        q->data[q->rear] = value;
        printf("Element %d enqueued successfully!\n", value);
    }
}

// function for deleting an element from the queue
void dequeue(struct Queue* q) {
    if (isEmpty(q)) {
        printf("Queue is empty!\n");
    } else {
        printf("Element %d dequeued successfully!\n", q->data[q->front]);
        if (q->front == q->rear) {
            q->front = -1;
            q->rear = -1;
        } else {
            q->front = (q->front + 1) % MAX_SIZE;
        }
    }
}

// function for displaying the contents of the queue
void display(struct Queue* q) {
    if (isEmpty(q)) {
        printf("Queue is empty!\n");
    } else {
        printf("Queue contains: ");
        int i;
        for (i = q->front; i <= q->rear; i = (i + 1) % MAX_SIZE) {
            printf("%d ", q->data[i]);
        }
        printf("\n");
    }
}

int main() {
    struct Queue q;
    createQueue(&q);
    enqueue(&q, 10);
    enqueue(&q, 20);
    display(&q);
    dequeue(&q);
    dequeue(&q);
    display(&q);
    enqueue(&q, 30);
    enqueue(&q, 40);
    display(&q);
    dequeue(&q);
    dequeue(&q);
    dequeue(&q);
    display(&q);
    return 0;
}