//Falcon2-11B DATASET v1.0 Category: Fibonacci Sequence Visualizer ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_F 100
#define NUM_ROWS 5
#define NUM_COLS 10

void print_fib(int f[MAX_F], int rows, int cols);
void draw_fib(int f[MAX_F], int rows, int cols);

int main(int argc, char **argv)
{
    int f[MAX_F] = {0};
    f[0] = 1;
    f[1] = 1;
    int rows = NUM_ROWS;
    int cols = NUM_COLS;
    print_fib(f, rows, cols);
    draw_fib(f, rows, cols);
    return 0;
}

void print_fib(int f[MAX_F], int rows, int cols)
{
    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            printf("%d ", f[i]);
        }
        printf("\n");
    }
}

void draw_fib(int f[MAX_F], int rows, int cols)
{
    char *pattern[MAX_F][MAX_F];

    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            if (f[i] == 0) {
                pattern[i][j] = "   ";
            } else if (f[i] == 1) {
                pattern[i][j] = "  +";
            } else if (f[i] == 2) {
                pattern[i][j] = " + ";
            } else {
                pattern[i][j] = "+  ";
            }
        }
    }

    printf("\n");

    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            printf("%s", pattern[i][j]);
        }
        printf("\n");
    }
}