//GEMINI-pro DATASET v1.0 Category: Percolation Simulator ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 10
#define HEIGHT 10

int grid[WIDTH][HEIGHT];

void init_grid() {
  for (int i = 0; i < WIDTH; i++) {
    for (int j = 0; j < HEIGHT; j++) {
      grid[i][j] = 0;
    }
  }
}

void print_grid() {
  for (int i = 0; i < WIDTH; i++) {
    for (int j = 0; j < HEIGHT; j++) {
      printf("%d ", grid[i][j]);
    }
    printf("\n");
  }
}

int is_open(int x, int y) {
  return grid[x][y] == 1;
}

void open_cell(int x, int y) {
  grid[x][y] = 1;
}

int count_open_cells() {
  int count = 0;
  for (int i = 0; i < WIDTH; i++) {
    for (int j = 0; j < HEIGHT; j++) {
      if (is_open(i, j)) {
        count++;
      }
    }
  }
  return count;
}

int main() {
  srand(time(NULL));

  init_grid();

  for (int i = 0; i < WIDTH; i++) {
    for (int j = 0; j < HEIGHT; j++) {
      if ((rand() % 100) < 50) {
        open_cell(i, j);
      }
    }
  }

  print_grid();

  printf("Number of open cells: %d\n", count_open_cells());

  return 0;
}