//Falcon-180B DATASET v1.0 Category: Percolation Simulator ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define SIZE 10

// Function to initialize the grid with blocked cells
void initialize(int grid[SIZE][SIZE]) {
    int i, j;
    for (i = 0; i < SIZE; i++) {
        for (j = 0; j < SIZE; j++) {
            grid[i][j] = 1;
        }
    }
}

// Function to check if a cell is open
int isOpen(int grid[SIZE][SIZE], int i, int j) {
    if (i < 0 || i >= SIZE || j < 0 || j >= SIZE) {
        return 0;
    }
    return grid[i][j];
}

// Function to check if a cell is blocked
int isBlocked(int grid[SIZE][SIZE], int i, int j) {
    return!isOpen(grid, i, j);
}

// Function to check the neighbors of a cell
int countOpenNeighbors(int grid[SIZE][SIZE], int i, int j) {
    int count = 0;
    if (isOpen(grid, i - 1, j)) {
        count++;
    }
    if (isOpen(grid, i + 1, j)) {
        count++;
    }
    if (isOpen(grid, i, j - 1)) {
        count++;
    }
    if (isOpen(grid, i, j + 1)) {
        count++;
    }
    return count;
}

// Function to percolate the grid
void percolate(int grid[SIZE][SIZE]) {
    int i, j;
    for (i = 0; i < SIZE; i++) {
        for (j = 0; j < SIZE; j++) {
            if (isBlocked(grid, i, j)) {
                int openNeighbors = countOpenNeighbors(grid, i, j);
                if (openNeighbors == 3) {
                    grid[i][j] = 0;
                }
            }
        }
    }
}

// Function to display the grid
void display(int grid[SIZE][SIZE]) {
    int i, j;
    for (i = 0; i < SIZE; i++) {
        for (j = 0; j < SIZE; j++) {
            if (isBlocked(grid, i, j)) {
                printf("* ");
            } else {
                printf("  ");
            }
        }
        printf("\n");
    }
}

int main() {
    srand(time(NULL));
    int grid[SIZE][SIZE];
    initialize(grid);
    percolate(grid);
    display(grid);
    return 0;
}