//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>

// Function to perform bitwise AND operation
unsigned int bitwise_and(unsigned int a, unsigned int b)
{
    return (a & b);
}

// Function to perform bitwise OR operation
unsigned int bitwise_or(unsigned int a, unsigned int b)
{
    return (a | b);
}

// Function to perform bitwise XOR operation
unsigned int bitwise_xor(unsigned int a, unsigned int b)
{
    return (a ^ b);
}

// Function to perform bitwise NOT operation
unsigned int bitwise_not(unsigned int a)
{
    return (~a);
}

// Function to perform bitwise left shift operation
unsigned int bitwise_left_shift(unsigned int a, int b)
{
    return (a << b);
}

// Function to perform bitwise right shift operation
unsigned int bitwise_right_shift(unsigned int a, int b)
{
    return (a >> b);
}

// Function to perform bitwise rotation operation
unsigned int bitwise_rotate(unsigned int a, int b)
{
    return ((a << b) | (a >> (32 - b)));
}

// Function to perform bitwise set operation
unsigned int bitwise_set(unsigned int a, int b)
{
    return (a | (1 << b));
}

// Function to perform bitwise clear operation
unsigned int bitwise_clear(unsigned int a, int b)
{
    return (a & ~(1 << b));
}

// Function to perform bitwise toggle operation
unsigned int bitwise_toggle(unsigned int a, int b)
{
    return (a ^ (1 << b));
}

int main()
{
    // Example usage of bitwise operations
    unsigned int a = 0b11010101;
    unsigned int b = 0b10101010;

    printf("Bitwise AND: %u\n", bitwise_and(a, b));
    printf("Bitwise OR: %u\n", bitwise_or(a, b));
    printf("Bitwise XOR: %u\n", bitwise_xor(a, b));
    printf("Bitwise NOT: %u\n", bitwise_not(a));
    printf("Bitwise left shift: %u\n", bitwise_left_shift(a, 2));
    printf("Bitwise right shift: %u\n", bitwise_right_shift(a, 2));
    printf("Bitwise rotation: %u\n", bitwise_rotate(a, 2));
    printf("Bitwise set: %u\n", bitwise_set(a, 2));
    printf("Bitwise clear: %u\n", bitwise_clear(a, 2));
    printf("Bitwise toggle: %u\n", bitwise_toggle(a, 2));

    return 0;
}