//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: lively
#include <stdio.h>
#include <stdlib.h>

int main() {
    int num1 = 0b10101010;
    int num2 = 0b01010101;
    int result;
    int i;

    // Bitwise AND operation
    result = num1 & num2;
    printf("Bitwise AND: %d\n", result);

    // Bitwise OR operation
    result = num1 | num2;
    printf("Bitwise OR: %d\n", result);

    // Bitwise XOR operation
    result = num1 ^ num2;
    printf("Bitwise XOR: %d\n", result);

    // Bitwise NOT operation
    result = ~num1;
    printf("Bitwise NOT: %d\n", result);

    // Bitwise left shift operation
    result = num1 << 2;
    printf("Bitwise left shift by 2: %d\n", result);

    // Bitwise right shift operation
    result = num1 >> 2;
    printf("Bitwise right shift by 2: %d\n", result);

    // Bitwise right shift with zero fill
    result = num1 >> 4;
    printf("Bitwise right shift with zero fill: %d\n", result);

    // Bitwise left shift with zero fill
    result = num2 << 4;
    printf("Bitwise left shift with zero fill: %d\n", result);

    // Bitwise AND operation with a single bit
    result = num1 & 0b00000001;
    printf("Bitwise AND with a single bit: %d\n", result);

    // Bitwise OR operation with a single bit
    result = num1 | 0b00000001;
    printf("Bitwise OR with a single bit: %d\n", result);

    // Bitwise XOR operation with a single bit
    result = num1 ^ 0b00000001;
    printf("Bitwise XOR with a single bit: %d\n", result);

    // Bitwise shift operations with a single bit
    for (i = 0; i < 8; i++) {
        result = num1 << i;
        printf("Bitwise left shift by %d: %d\n", i, result);
    }

    for (i = 0; i < 8; i++) {
        result = num1 >> i;
        printf("Bitwise right shift by %d: %d\n", i, result);
    }

    return 0;
}