//Code Llama-13B DATASET v1.0 Category: Geometric algorithms ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define a struct for a point in 2D space
struct Point {
  double x;
  double y;
};

// Define a struct for a line in 2D space
struct Line {
  struct Point start;
  struct Point end;
};

// Define a struct for a rectangle in 2D space
struct Rectangle {
  struct Point top_left;
  struct Point bottom_right;
};

// Define a struct for a circle in 2D space
struct Circle {
  struct Point center;
  double radius;
};

// Function to calculate the intersection point between two lines
struct Point line_intersection(struct Line line1, struct Line line2) {
  double x1 = line1.start.x;
  double y1 = line1.start.y;
  double x2 = line1.end.x;
  double y2 = line1.end.y;
  double x3 = line2.start.x;
  double y3 = line2.start.y;
  double x4 = line2.end.x;
  double y4 = line2.end.y;
  double denom = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
  double x = ((x1 * y2 - y1 * x2) * (x3 - x4) - (x1 - x2) * (x3 * y4 - y3 * x4)) / denom;
  double y = ((x1 * y2 - y1 * x2) * (y3 - y4) - (y1 - y2) * (x3 * y4 - y3 * x4)) / denom;
  struct Point intersection = {x, y};
  return intersection;
}

// Function to calculate the intersection point between a line and a rectangle
struct Point line_rectangle_intersection(struct Line line, struct Rectangle rectangle) {
  struct Point top_left = rectangle.top_left;
  struct Point bottom_right = rectangle.bottom_right;
  double x1 = line.start.x;
  double y1 = line.start.y;
  double x2 = line.end.x;
  double y2 = line.end.y;
  double x3 = top_left.x;
  double y3 = top_left.y;
  double x4 = bottom_right.x;
  double y4 = bottom_right.y;
  double denom = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
  double x = ((x1 * y2 - y1 * x2) * (x3 - x4) - (x1 - x2) * (x3 * y4 - y3 * x4)) / denom;
  double y = ((x1 * y2 - y1 * x2) * (y3 - y4) - (y1 - y2) * (x3 * y4 - y3 * x4)) / denom;
  struct Point intersection = {x, y};
  return intersection;
}

// Function to calculate the intersection point between a line and a circle
struct Point line_circle_intersection(struct Line line, struct Circle circle) {
  struct Point center = circle.center;
  double radius = circle.radius;
  double x1 = line.start.x;
  double y1 = line.start.y;
  double x2 = line.end.x;
  double y2 = line.end.y;
  double xc = center.x;
  double yc = center.y;
  double r = radius;
  double a = (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
  double b = 2 * ((x2 - x1) * (xc - x1) + (y2 - y1) * (yc - y1));
  double c = (xc - x1) * (xc - x1) + (yc - y1) * (yc - y1) - r * r;
  double discriminant = b * b - 4 * a * c;
  if (discriminant < 0) {
    // No intersection
    struct Point intersection = {-1, -1};
    return intersection;
  } else {
    // Two intersection points
    double t1 = (-b + sqrt(discriminant)) / (2 * a);
    double t2 = (-b - sqrt(discriminant)) / (2 * a);
    struct Point intersection1 = {x1 + t1 * (x2 - x1), y1 + t1 * (y2 - y1)};
    struct Point intersection2 = {x1 + t2 * (x2 - x1), y1 + t2 * (y2 - y1)};
    return intersection1;
  }
}

int main() {
  // Define two lines
  struct Line line1 = {{1, 1}, {3, 3}};
  struct Line line2 = {{2, 2}, {4, 4}};

  // Calculate the intersection point between two lines
  struct Point intersection = line_intersection(line1, line2);
  printf("Intersection point between two lines: (%lf, %lf)\n", intersection.x, intersection.y);

  // Define a rectangle
  struct Rectangle rectangle = {{1, 1}, {3, 3}};

  // Calculate the intersection point between a line and a rectangle
  intersection = line_rectangle_intersection(line1, rectangle);
  printf("Intersection point between a line and a rectangle: (%lf, %lf)\n", intersection.x, intersection.y);

  // Define a circle
  struct Circle circle = {{2, 2}, 1};

  // Calculate the intersection point between a line and a circle
  intersection = line_circle_intersection(line1, circle);
  printf("Intersection point between a line and a circle: (%lf, %lf)\n", intersection.x, intersection.y);

  return 0;
}