//LLAMA2-13B DATASET v1.0 Category: Matrix operations ; Style: invasive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define N 10

int main() {
    int i, j, k;
    char matrix[N][N];
    char invaded[N][N];

    // Initialize the matrices
    for (i = 0; i < N; i++) {
        for (j = 0; j < N; j++) {
            matrix[i][j] = i * j;
            invaded[i][j] = 0;
        }
    }

    // Invade the matrix
    for (i = 0; i < N; i++) {
        for (j = 0; j < N; j++) {
            if (matrix[i][j] % 2 == 0) {
                // Invade the cell
                invaded[i][j] = matrix[i][j];
                // Invade the neighbors
                if (i > 0 && matrix[i - 1][j] % 2 == 0) {
                    invaded[i - 1][j] = matrix[i - 1][j] + invaded[i][j];
                }
                if (i < N - 1 && matrix[i + 1][j] % 2 == 0) {
                    invaded[i + 1][j] = matrix[i + 1][j] + invaded[i][j];
                }
                if (j > 0 && matrix[i][j - 1] % 2 == 0) {
                    invaded[i][j - 1] = matrix[i][j - 1] + invaded[i][j];
                }
                if (j < N - 1 && matrix[i][j + 1] % 2 == 0) {
                    invaded[i][j + 1] = matrix[i][j + 1] + invaded[i][j];
                }
            }
        }
    }

    // Print the invaded matrix
    for (i = 0; i < N; i++) {
        for (j = 0; j < N; j++) {
            printf("%d ", invaded[i][j]);
        }
        printf("\n");
    }

    return 0;
}