//GPT-4o-mini DATASET v1.0 Category: Interprocess communication ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <mqueue.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>

#define MQ_NAME "/demo_mq"
#define MAX_MSG_SIZE 128
#define MAX_MSGBUF 10

typedef struct msgbuf {
    long mtype; // Message type
    int number; // Random number
} msgbuf;

void producer() {
    mqd_t mq;
    msgbuf msg;
    
    // Create a message queue
    mq = mq_open(MQ_NAME, O_CREAT | O_WRONLY, 0644, NULL);
    if (mq == (mqd_t)-1) {
        perror("Producer: mq_open");
        exit(EXIT_FAILURE);
    }

    srand(time(NULL)); // Seed the random number generator

    for (int i = 0; i < 20; i++) {
        msg.mtype = 1; // Message type (not used but required)
        msg.number = rand() % 100; // Generate a random number between 0 and 99

        // Send the message to the queue
        if (mq_send(mq, (const char*)&msg, sizeof(msg), 0) == -1) {
            perror("Producer: mq_send");
            exit(EXIT_FAILURE);
        }

        printf("Producer: Sent number %d\n", msg.number);
        sleep(1); // Sleep to simulate work
    }

    // Close the message queue
    mq_close(mq);
    printf("Producer: Finished sending numbers.\n");
}

void consumer() {
    mqd_t mq;
    msgbuf msg;

    // Open the message queue
    mq = mq_open(MQ_NAME, O_RDONLY);
    if (mq == (mqd_t)-1) {
        perror("Consumer: mq_open");
        exit(EXIT_FAILURE);
    }

    for (int i = 0; i < 20; i++) {
        // Receive the message from the queue
        if (mq_receive(mq, (char*)&msg, sizeof(msg), NULL) == -1) {
            perror("Consumer: mq_receive");
            exit(EXIT_FAILURE);
        }

        printf("Consumer: Received number %d\n", msg.number);
    }

    // Close the message queue
    mq_close(mq);
    mq_unlink(MQ_NAME); // Remove the message queue
    printf("Consumer: Finished receiving numbers.\n");
}

int main() {
    pid_t pid = fork();

    if (pid < 0) {
        perror("Fork failed");
        exit(EXIT_FAILURE);
    } else if (pid > 0) { // Parent process: Producer
        producer();
    } else { // Child process: Consumer
        consumer();
    }

    return 0;
}