//Gemma-7B DATASET v1.0 Category: Port Scanner ; Style: complete
#include <stdio.h>
#include <netdb.h>
#include <sys/socket.h>

#define SERVER_PORT 8888
#define BUFFER_SIZE 1024

int main()
{
    int sockfd, newsockfd, port, clientlen;
    struct sockaddr_in server_addr, client_addr;

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, htons(SERVER_PORT));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        return 1;
    }

    // Bind the socket to a port
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(SERVER_PORT);
    if (bind(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0)
    {
        perror("Error binding socket");
        return 1;
    }

    // Listen for clients
    listen(sockfd, &clientlen);

    // Accept a client connection
    newsockfd = accept(sockfd, (struct sockaddr *)&client_addr, &clientlen);
    if (newsockfd < 0)
    {
        perror("Error accepting client connection");
        return 1;
    }

    // Send and receive data
    char buffer[BUFFER_SIZE];
    int bytes_read, bytes_written;

    // Receive data from the client
    bytes_read = recv(newsockfd, buffer, BUFFER_SIZE, 0);
    if (bytes_read < 0)
    {
        perror("Error receiving data");
        return 1;
    }

    // Print the data received from the client
    printf("Data received from client: %s", buffer);

    // Send data to the client
    bytes_written = send(newsockfd, buffer, bytes_read, 0);
    if (bytes_written < 0)
    {
        perror("Error sending data");
        return 1;
    }

    // Close the client connection
    close(newsockfd);

    // Close the socket
    close(sockfd);

    return 0;
}