//GPT-4o-mini DATASET v1.0 Category: Secure Password Generator ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define PASSWORD_LENGTH 12 // Default password length
#define LOWERCASE "abcdefghijklmnopqrstuvwxyz"
#define UPPERCASE "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
#define DIGITS "0123456789"
#define SPECIAL_CHARS "!@#$%^&*()_-+=<>?"

void generatePassword(char *password, int length) {
    const char *allChars = LOWERCASE UPPERCASE DIGITS SPECIAL_CHARS; // Concatenating all characters
    int allCharsLength = strlen(allChars); // Length of combined character set

    // Ensure there's at least one character from each category
    password[0] = LOWERCASE[rand() % strlen(LOWERCASE)];
    password[1] = UPPERCASE[rand() % strlen(UPPERCASE)];
    password[2] = DIGITS[rand() % strlen(DIGITS)];
    password[3] = SPECIAL_CHARS[rand() % strlen(SPECIAL_CHARS)];

    // Filling the remaining characters with random choices from the combined set
    for (int i = 4; i < length; i++) {
        password[i] = allChars[rand() % allCharsLength];
    }

    // Shuffle the password to avoid predictable patterns
    for (int i = 0; i < length; i++) {
        int j = rand() % length;
        char temp = password[i];
        password[i] = password[j];
        password[j] = temp;
    }

    password[length] = '\0'; // Null-terminate the string
}

int main() {
    int length = PASSWORD_LENGTH; // Default length can be modified
    char password[PASSWORD_LENGTH + 1]; // +1 for the null terminator
    
    // Seed the random number generator
    srand(time(NULL));

    // Generate password
    generatePassword(password, length);

    // Display the password
    printf("Generated Secure Password: %s\n", password);

    return 0;
}