//GEMINI-pro DATASET v1.0 Category: Percolation Simulator ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <stdbool.h>

#define N 10  // Size of the lattice

// Lattice of sites
bool lattice[N][N];

// Initialize the lattice
void init_lattice() {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            lattice[i][j] = rand() % 2;
        }
    }
}

// Print the lattice
void print_lattice() {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            printf("%d ", lattice[i][j]);
        }
        printf("\n");
    }
}

// Check if a site is open
bool is_open(int i, int j) {
    return lattice[i][j];
}

// Check if a site is closed
bool is_closed(int i, int j) {
    return !lattice[i][j];
}

// Check if a site is on the top boundary
bool is_top(int i) {
    return i == 0;
}

// Check if a site is on the bottom boundary
bool is_bottom(int i) {
    return i == N - 1;
}

// Check if a site is on the left boundary
bool is_left(int j) {
    return j == 0;
}

// Check if a site is on the right boundary
bool is_right(int j) {
    return j == N - 1;
}

// Check if a site is on the boundary
bool is_boundary(int i, int j) {
    return is_top(i) || is_bottom(i) || is_left(j) || is_right(j);
}

// Check if a site is percolating
bool is_percolating(int i, int j) {
    if (is_boundary(i, j)) {
        return true;
    }
    if (is_closed(i, j)) {
        return false;
    }
    // Check if the site is connected to the top boundary
    if (is_open(i - 1, j) && is_percolating(i - 1, j)) {
        return true;
    }
    // Check if the site is connected to the bottom boundary
    if (is_open(i + 1, j) && is_percolating(i + 1, j)) {
        return true;
    }
    // Check if the site is connected to the left boundary
    if (is_open(i, j - 1) && is_percolating(i, j - 1)) {
        return true;
    }
    // Check if the site is connected to the right boundary
    if (is_open(i, j + 1) && is_percolating(i, j + 1)) {
        return true;
    }
    return false;
}

// Main function
int main() {
    init_lattice();
    print_lattice();
    bool percolating = false;
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            if (is_percolating(i, j)) {
                percolating = true;
                break;
            }
        }
    }
    printf("The lattice is %s percolating\n", percolating ? "" : "not");
    return 0;
}