//Gemma-7B DATASET v1.0 Category: Stock market tracker ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

#define MAX_STOCK_NUM 10
#define UPDATE_INTERVAL 5

typedef struct Stock {
    char name[20];
    double current_price;
    double previous_price;
    double change_percentage;
} Stock;

void update_stock_prices(Stock *stocks, int num_stocks) {
    for (int i = 0; i < num_stocks; i++) {
        stocks[i].current_price = rand() % 1000;
        stocks[i].previous_price = rand() % 1000;
        stocks[i].change_percentage = (stocks[i].current_price - stocks[i].previous_price) / stocks[i].previous_price * 100;
    }
}

int main() {
    Stock stocks[MAX_STOCK_NUM];
    int num_stocks = 0;

    for (int i = 0; i < MAX_STOCK_NUM; i++) {
        stocks[i].name[0] = '\0';
        stocks[i].current_price = 0.0;
        stocks[i].previous_price = 0.0;
        stocks[i].change_percentage = 0.0;
    }

    update_stock_prices(stocks, num_stocks);

    printf("Stock Prices:\n");
    for (int i = 0; i < num_stocks; i++) {
        printf("%s: %.2f, %.2f, %.2f%\n", stocks[i].name, stocks[i].current_price, stocks[i].previous_price, stocks[i].change_percentage);
    }

    printf("\n");

    sleep(UPDATE_INTERVAL);

    update_stock_prices(stocks, num_stocks);

    printf("Updated Stock Prices:\n");
    for (int i = 0; i < num_stocks; i++) {
        printf("%s: %.2f, %.2f, %.2f%\n", stocks[i].name, stocks[i].current_price, stocks[i].previous_price, stocks[i].change_percentage);
    }

    return 0;
}