//GEMINI-pro DATASET v1.0 Category: Cryptography Implementation ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/sha.h>

int main()
{
  // A simple SHA-256 hashing function
  unsigned char hash[SHA256_DIGEST_LENGTH];
  SHA256_CTX sha256;
  SHA256_Init(&sha256);
  SHA256_Update(&sha256, "Hello, world!", strlen("Hello, world!"));
  SHA256_Final(hash, &sha256);

  // Print the hash
  printf("SHA-256 hash: ");
  for (int i = 0; i < SHA256_DIGEST_LENGTH; i++)
  {
    printf("%02x", hash[i]);
  }
  printf("\n");

  // A simple Caesar cipher
  char plaintext[] = "Hello, world!";
  char ciphertext[strlen(plaintext) + 1];
  int key = 3;
  for (int i = 0; i < strlen(plaintext); i++)
  {
    ciphertext[i] = plaintext[i] + key;
  }
  ciphertext[strlen(plaintext)] = '\0';

  // Print the ciphertext
  printf("Caesar cipher ciphertext: %s\n", ciphertext);

  // A simple Vigenere cipher
  char plaintext2[] = "Hello, world!";
  char ciphertext2[strlen(plaintext2) + 1];
  char key2[] = "KEY";
  int key_len = strlen(key2);
  for (int i = 0; i < strlen(plaintext2); i++)
  {
    ciphertext2[i] = plaintext2[i] + key2[i % key_len];
  }
  ciphertext2[strlen(plaintext2)] = '\0';

  // Print the ciphertext
  printf("Vigenere cipher ciphertext: %s\n", ciphertext2);

  return 0;
}