//LLAMA2-13B DATASET v1.0 Category: Networking ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <sys/wait.h>

#define PORT 8080

int main(int argc, char *argv[]) {
    int sock, conn_sock;
    struct sockaddr_in server, client;
    socklen_t client_len = sizeof(client);
    char buffer[256];

    // Create the server socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("Socket creation failed");
        exit(1);
    }

    // Set address and port number for the server
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = htons(PORT);

    // Bind the server socket to the address and port
    if (bind(sock, (struct sockaddr *)&server, sizeof(server)) < 0) {
        perror("Binding failed");
        exit(1);
    }

    // Listen for incoming connections
    if (listen(sock, 3) < 0) {
        perror("Listening failed");
        exit(1);
    }

    printf("Server listening on port %d...\n", PORT);

    while (1) {
        // Accept an incoming connection
        conn_sock = accept(sock, (struct sockaddr *)&client, &client_len);
        if (conn_sock < 0) {
            perror("Accept failed");
            exit(1);
        }

        // Receive data from the client
        recv(conn_sock, buffer, 256, 0);
        printf("Received message from client: %s\n", buffer);

        // Send a response back to the client
        send(conn_sock, "Hello, client!", 13, 0);

        // Close the connection
        close(conn_sock);
    }

    return 0;
}

int main2(int argc, char *argv[]) {
    int sock, conn_sock;
    struct sockaddr_in server, client;
    socklen_t client_len = sizeof(client);
    char buffer[256];

    // Create the client socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("Socket creation failed");
        exit(1);
    }

    // Set address and port number for the server
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = inet_addr("192.168.1.100");
    server.sin_port = htons(PORT);

    // Connect to the server
    if (connect(sock, (struct sockaddr *)&server, sizeof(server)) < 0) {
        perror("Connecting failed");
        exit(1);
    }

    // Send a message to the server
    send(sock, "Hello, server!", 13, 0);

    // Receive a response from the server
    recv(sock, buffer, 256, 0);
    printf("Received message from server: %s\n", buffer);

    // Close the connection
    close(sock);

    return 0;
}