//GEMINI-pro DATASET v1.0 Category: Appointment Scheduler ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// maximum number of appointments
#define MAX_APPOINTMENTS 10

// structure to store an appointment
typedef struct {
    char name[50];
    char time[20];
    char date[20];
} appointment;

// array to store appointments
appointment appointments[MAX_APPOINTMENTS];

// index of the next available appointment slot
int next_available_slot = 0;

// function to add an appointment
void add_appointment(char *name, char *time, char *date) {
    // check if there are any available slots
    if (next_available_slot == MAX_APPOINTMENTS) {
        printf("Sorry, there are no available slots.\n");
        return;
    }

    // copy the appointment details into the array
    strcpy(appointments[next_available_slot].name, name);
    strcpy(appointments[next_available_slot].time, time);
    strcpy(appointments[next_available_slot].date, date);

    // increment the index of the next available slot
    next_available_slot++;

    // print a success message
    printf("Appointment added successfully!\n");
}

// function to print all appointments
void print_appointments() {
    // check if there are any appointments
    if (next_available_slot == 0) {
        printf("There are no appointments scheduled.\n");
        return;
    }

    // print the header
    printf("Here are the scheduled appointments:\n");

    // loop through the appointments and print them
    for (int i = 0; i < next_available_slot; i++) {
        printf("%s - %s - %s\n", appointments[i].name, appointments[i].time, appointments[i].date);
    }
}

// function to delete an appointment
void delete_appointment(char *name) {
    // loop through the appointments and find the one to delete
    for (int i = 0; i < next_available_slot; i++) {
        if (strcmp(appointments[i].name, name) == 0) {
            // shift the remaining appointments down one slot
            for (int j = i; j < next_available_slot - 1; j++) {
                appointments[j] = appointments[j + 1];
            }

            // decrement the index of the next available slot
            next_available_slot--;

            // print a success message
            printf("Appointment deleted successfully!\n");
            return;
        }
    }

    // if the appointment was not found, print an error message
    printf("Appointment not found.\n");
}

// main function
int main() {
    // add some sample appointments
    add_appointment("John Doe", "10:00 AM", "01/01/2023");
    add_appointment("Jane Doe", "11:00 AM", "01/02/2023");
    add_appointment("Bill Smith", "12:00 PM", "01/03/2023");

    // print the appointments
    print_appointments();

    // delete an appointment
    delete_appointment("John Doe");

    // print the appointments again
    print_appointments();

    return 0;
}