//GEMINI-pro DATASET v1.0 Category: Password management ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum length of a password
#define MAX_PASSWORD_LENGTH 32

// Define the number of passwords to store
#define NUM_PASSWORDS 10

// Define the structure of a password entry
typedef struct {
    char username[MAX_PASSWORD_LENGTH];
    char password[MAX_PASSWORD_LENGTH];
} password_entry;

// Define the array of password entries
password_entry passwords[NUM_PASSWORDS];

// Define the current index of the password entry
int current_index = 0;

// Function to add a new password entry
void add_password_entry(char *username, char *password) {
    // Check if the array of password entries is full
    if (current_index == NUM_PASSWORDS) {
        printf("Error: The array of password entries is full.\n");
        return;
    }

    // Copy the username and password into the array of password entries
    strcpy(passwords[current_index].username, username);
    strcpy(passwords[current_index].password, password);

    // Increment the current index
    current_index++;
}

// Function to search for a password entry
password_entry *search_password_entry(char *username) {
    // Loop through the array of password entries
    for (int i = 0; i < current_index; i++) {
        // Check if the username matches the username of the password entry
        if (strcmp(passwords[i].username, username) == 0) {
            // Return the password entry
            return &passwords[i];
        }
    }

    // Return NULL if the username was not found
    return NULL;
}

// Function to print the password entries
void print_password_entries() {
    // Loop through the array of password entries
    for (int i = 0; i < current_index; i++) {
        // Print the username and password of the password entry
        printf("%s: %s\n", passwords[i].username, passwords[i].password);
    }
}

// Function to main
int main() {
    // Add some password entries to the array of password entries
    add_password_entry("admin", "password");
    add_password_entry("user", "password");
    add_password_entry("guest", "password");

    // Search for a password entry
    password_entry *password_entry = search_password_entry("admin");

    // Print the password entry
    if (password_entry != NULL) {
        printf("Username: %s\n", password_entry->username);
        printf("Password: %s\n", password_entry->password);
    } else {
        printf("Error: The username was not found.\n");
    }

    // Print all the password entries
    print_password_entries();

    return 0;
}