//LLAMA2-13B DATASET v1.0 Category: Socket programming ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main() {
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("Socket creation failed");
        exit(1);
    }

    struct sockaddr_in server_addr = {
        .sin_family = AF_INET,
        .sin_port = htons(PORT),
        .sin_addr.s_addr = inet_addr("127.0.0.1")
    };

    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("Connect failed");
        exit(1);
    }

    char buffer[1024];
    int recv_len = recv(sock, buffer, 1024, 0);
    if (recv_len < 0) {
        perror("Recv failed");
        exit(1);
    }

    printf("Received message: %s\n", buffer);

    char message[] = "Hello, client!";
    int send_len = send(sock, message, strlen(message), 0);
    if (send_len < 0) {
        perror("Send failed");
        exit(1);
    }

    char buffer2[1024];
    recv_len = recv(sock, buffer2, 1024, 0);
    if (recv_len < 0) {
        perror("Recv failed");
        exit(1);
    }

    printf("Received message2: %s\n", buffer2);

    close(sock);
    return 0;
}