//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>

int main(void) {
    // Declare variables
    int a = 5;  // Binary: 0101
    int b = 3;  // Binary: 0011

    // Bitwise AND (&)
    int c = a & b;  // Result: 0001 (1)
    printf("Bitwise AND (a & b): %d\n", c);

    // Bitwise OR (|)
    int d = a | b;  // Result: 0111 (7)
    printf("Bitwise OR (a | b): %d\n", d);

    // Bitwise XOR (^)
    int e = a ^ b;  // Result: 0110 (6)
    printf("Bitwise XOR (a ^ b): %d\n", e);

    // Bitwise NOT (~)
    int f = ~a;  // Result: 1010 (-6)
    printf("Bitwise NOT (~a): %d\n", f);

    // Bitwise left shift (<<)
    int g = a << 2;  // Result: 10100 (20)
    printf("Bitwise left shift (a << 2): %d\n", g);

    // Bitwise right shift (>>)
    int h = a >> 1;  // Result: 0010 (2)
    printf("Bitwise right shift (a >> 1): %d\n", h);

    // Check if a number is even or odd
    if (a & 1) {
        printf("%d is odd\n", a);
    } else {
        printf("%d is even\n", a);
    }

    // Check if a number is a power of 2
    if ((a & (a - 1)) == 0) {
        printf("%d is a power of 2\n", a);
    } else {
        printf("%d is not a power of 2\n", a);
    }

    // Swap two numbers using bitwise XOR
    a = a ^ b;
    b = a ^ b;
    a = a ^ b;
    printf("a: %d, b: %d\n", a, b);

    // Set the nth bit of a number
    int n = 2;  // Position of the bit to set (0-based)
    int mask = 1 << n;  // Create a bitmask with the nth bit set
    a = a | mask;  // Set the nth bit of a
    printf("Nth bit set (a | mask): %d\n", a);

    // Clear the nth bit of a number
    mask = ~(1 << n);  // Create a bitmask with the nth bit cleared
    a = a & mask;  // Clear the nth bit of a
    printf("Nth bit cleared (a & mask): %d\n", a);

    // Toggle the nth bit of a number
    a = a ^ (1 << n);  // Toggle the nth bit of a
    printf("Nth bit toggled (a ^ mask): %d\n", a);

    // Extract the nth bit of a number
    int bit = (a & (1 << n)) >> n;  // Shift the nth bit to the least significant position
    printf("Extracted nth bit (a & mask >> n): %d\n", bit);

    return 0;
}