//Falcon2-11B DATASET v1.0 Category: Haunted House Simulator ; Style: imaginative
#include<stdio.h>
#include<stdlib.h>
#include<time.h>

int main() {
    srand(time(NULL)); //initialize random number generator

    int size = 20; //number of rooms
    int num_ghosts = 10; //number of ghosts
    int current_room = 0; //current room number
    int next_room; //next room number
    int ghost_count = 0; //number of ghosts encountered

    printf("Welcome to the Haunted House Simulator!\n");

    for(int i = 1; i <= size; i++) {
        char room_name[20];
        sprintf(room_name, "%d", i); //room name
        char* door_name[4] = {"Wooden","Glass","Metal","Stone"}; //types of doors

        printf("\nRoom %s\n", room_name);
        printf("The door to your left is %s\n", door_name[rand() % 4]);
        printf("The door to your right is %s\n", door_name[rand() % 4]);
        printf("You hear a faint whispering in the distance.\n");

        next_room = rand() % 4; //random number to decide next direction
        if(next_room == 0) { //go left
            current_room += 1; //increment current room
        } else if(next_room == 1) { //go right
            current_room -= 1; //decrement current room
        } else if(next_room == 2) { //go forward
            current_room += 1; //increment current room
        } else if(next_room == 3) { //go back
            current_room -= 1; //decrement current room
        }

        if(current_room == 0) { //start room
            printf("You are back at the start room.\n");
            printf("A ghost appears before you!\n");
            printf("It whispers 'Boo!'.\n");
            ghost_count += 1; //increment ghost count
        } else if(current_room == size) { //end room
            printf("You have reached the end of the haunted house.\n");
            printf("You escaped the ghost!\n");
            printf("You are safe now.\n");
        } else {
            printf("You continue through the haunted house.\n");
            printf("You hear more whispering and footsteps.\n");
        }

        printf("Ghosts encountered: %d\n", ghost_count);

        if(ghost_count >= num_ghosts) { //if enough ghosts encountered
            printf("Congratulations! You escaped the haunted house.\n");
            break; //exit loop
        }
    }

    return 0;
}