//Gemma-7B DATASET v1.0 Category: Stock market tracker ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX_STOCK_NUM 10
#define MAX_STOCK_PRICE 1000

typedef struct Stock
{
    char name[20];
    double current_price;
    double previous_price;
    double change_percentage;
} Stock;

Stock stocks[MAX_STOCK_NUM];

void calculate_stock_changes(void)
{
    for (int i = 0; i < MAX_STOCK_NUM; i++)
    {
        stocks[i].change_percentage = (stocks[i].current_price - stocks[i].previous_price) / stocks[i].previous_price * 100.0;
    }
}

void print_stock_changes(void)
{
    for (int i = 0; i < MAX_STOCK_NUM; i++)
    {
        printf("%s: %.2f%% change\n", stocks[i].name, stocks[i].change_percentage);
    }
}

int main(void)
{
    // Initialize the stock data
    for (int i = 0; i < MAX_STOCK_NUM; i++)
    {
        stocks[i].name[0] = '\0';
        stocks[i].current_price = 0.0;
        stocks[i].previous_price = 0.0;
        stocks[i].change_percentage = 0.0;
    }

    // Calculate the stock changes
    calculate_stock_changes();

    // Print the stock changes
    print_stock_changes();

    return 0;
}