//Code Llama-13B DATASET v1.0 Category: Task Scheduler ; Style: rigorous
// TaskScheduler.c

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>

#define MAX_TASKS 10
#define MAX_TASK_NAME_LEN 32

typedef struct {
    char name[MAX_TASK_NAME_LEN];
    int period;
    int duration;
} Task;

void task_scheduler() {
    Task tasks[MAX_TASKS];
    int num_tasks = 0;

    while (1) {
        // Check if there are any tasks to be executed
        if (num_tasks == 0) {
            // Sleep for 1 second
            sleep(1);
            continue;
        }

        // Check if the current time matches the period of any task
        time_t now = time(NULL);
        for (int i = 0; i < num_tasks; i++) {
            if (now % tasks[i].period == 0) {
                // Execute the task
                printf("Executing task %s\n", tasks[i].name);
                sleep(tasks[i].duration);

                // Mark the task as completed
                tasks[i].period = 0;
            }
        }

        // Remove completed tasks
        for (int i = 0; i < num_tasks; i++) {
            if (tasks[i].period == 0) {
                memmove(&tasks[i], &tasks[i + 1], (num_tasks - i - 1) * sizeof(Task));
                num_tasks--;
            }
        }
    }
}

int main() {
    task_scheduler();
    return 0;
}