//GPT-4o-mini DATASET v1.0 Category: System event logger ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define LOG_FILE "event_log.txt"

typedef enum {
    INFO,
    WARNING,
    ERROR,
    DEBUG
} LogLevel;

const char *logLevelToString(LogLevel level) {
    switch (level) {
        case INFO: return "INFO";
        case WARNING: return "WARNING";
        case ERROR: return "ERROR";
        case DEBUG: return "DEBUG";
        default: return "UNKNOWN";
    }
}

void getCurrentTime(char *buffer, size_t size) {
    time_t now = time(NULL);
    struct tm *tm_info = localtime(&now);
    strftime(buffer, size, "%Y-%m-%d %H:%M:%S", tm_info);
}

void logEvent(LogLevel level, const char *message) {
    FILE *file = fopen(LOG_FILE, "a");
    if (file == NULL) {
        perror("Could not open log file");
        return;
    }

    char timestamp[20];
    getCurrentTime(timestamp, sizeof(timestamp));

    fprintf(file, "[%s] [%s] %s\n", timestamp, logLevelToString(level), message);
    fclose(file);
}

void logInfo(const char *message) {
    logEvent(INFO, message);
}

void logWarning(const char *message) {
    logEvent(WARNING, message);
}

void logError(const char *message) {
    logEvent(ERROR, message);
}

void logDebug(const char *message) {
    logEvent(DEBUG, message);
}

void simulateApplication() {
    logInfo("Application started.");
    logDebug("Entering main procedure.");

    int riskFactor = rand() % 10;
    if (riskFactor < 4) {
        logWarning("Risk factor is low but not negligible.");
    } else if (riskFactor < 8) {
        logError("Risk factor is high! Immediate action required!");
    }

    logInfo("Application finished processing.");
    logDebug("Exiting main procedure.");
}

int main() {
    srand(time(NULL));
    
    logInfo("Event logger initialized.");
    simulateApplication();
    
    logInfo("Event logger terminated.");
    return 0;
}