//GPT-4o-mini DATASET v1.0 Category: Cryptography Implementation ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/aes.h>
#include <openssl/rand.h>

// Function to handle error
void handleErrors() {
    fprintf(stderr, "An error occurred!\n");
    exit(EXIT_FAILURE);
}

// Function to encrypt the plaintext using AES
int aes_encrypt(const unsigned char *key, const unsigned char *plaintext, unsigned char *ciphertext) {
    AES_KEY encryptKey;
    if (AES_set_encrypt_key(key, 128, &encryptKey) < 0) {
        handleErrors();
    }

    AES_encrypt(plaintext, ciphertext, &encryptKey);
    return 0;
}

// Function to decrypt the ciphertext using AES
int aes_decrypt(const unsigned char *key, const unsigned char *ciphertext, unsigned char *plaintext) {
    AES_KEY decryptKey;
    if (AES_set_decrypt_key(key, 128, &decryptKey) < 0) {
        handleErrors();
    }

    AES_decrypt(ciphertext, plaintext, &decryptKey);
    return 0;
}

// Function to display the byte array in hexadecimal format
void print_hex(unsigned char *buf, int length) {
    for (int i = 0; i < length; i++) {
        printf("%02x", buf[i]);
    }
    printf("\n");
}

// Main function to demonstrate AES encryption and decryption
int main() {
    // Define AES key and plaintext
    unsigned char key[16]; // AES-128
    unsigned char plaintext[16] = "Hello, World!!!"; // 16 bytes of data
    unsigned char ciphertext[16];
    unsigned char decryptedtext[16];

    // Generate a random AES key
    if(!RAND_bytes(key, sizeof(key))) {
        handleErrors();
    }

    printf("Original Plaintext: %s\n", plaintext);
    
    // Encrypt the plaintext
    aes_encrypt(key, plaintext, ciphertext);
    
    printf("Ciphertext: ");
    print_hex(ciphertext, sizeof(ciphertext));

    // Decrypt the ciphertext
    aes_decrypt(key, ciphertext, decryptedtext);
    
    printf("Decrypted Plaintext: %s\n", decryptedtext);

    // Validate the decryption
    if (strncmp((char *)plaintext, (char *)decryptedtext, sizeof(plaintext)) == 0) {
        printf("Decryption successful: Original matches Decrypted!\n");
    } else {
        printf("Decryption failed: Original does not match Decrypted!\n");
    }

    return 0;
}