//Falcon-180B DATASET v1.0 Category: Task Scheduler ; Style: funny
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_TASKS 100

typedef struct {
    int id;
    char *name;
    int priority;
    int burst_time;
    int waiting_time;
    int turnaround_time;
} Task;

void add_task(Task *tasks, int num_tasks, int id, char *name, int priority, int burst_time) {
    if (num_tasks >= MAX_TASKS) {
        printf("Sorry, can't add more tasks!\n");
        return;
    }
    tasks[num_tasks].id = id;
    tasks[num_tasks].name = name;
    tasks[num_tasks].priority = priority;
    tasks[num_tasks].burst_time = burst_time;
    num_tasks++;
}

void print_tasks(Task *tasks, int num_tasks) {
    printf("Task ID\tTask Name\tPriority\tBurst Time\n");
    for (int i = 0; i < num_tasks; i++) {
        printf("%d\t%s\t%d\t%d\n", tasks[i].id, tasks[i].name, tasks[i].priority, tasks[i].burst_time);
    }
}

void execute_tasks(Task *tasks, int num_tasks) {
    int completed_tasks = 0;
    int current_time = 0;
    while (completed_tasks < num_tasks) {
        int min_burst_time = 999999;
        int min_index = -1;
        for (int i = 0; i < num_tasks; i++) {
            if (tasks[i].burst_time > 0 && tasks[i].burst_time <= min_burst_time) {
                min_burst_time = tasks[i].burst_time;
                min_index = i;
            }
        }
        if (min_index == -1) {
            current_time++;
        } else {
            tasks[min_index].burst_time--;
            if (tasks[min_index].burst_time == 0) {
                completed_tasks++;
            }
        }
    }
    printf("All tasks completed in %d time units.\n", current_time);
}

int main() {
    Task tasks[MAX_TASKS];
    int num_tasks = 0;

    add_task(tasks, num_tasks, 1, "Task A", 5, 3);
    add_task(tasks, num_tasks, 2, "Task B", 3, 2);
    add_task(tasks, num_tasks, 3, "Task C", 7, 5);

    print_tasks(tasks, num_tasks);

    execute_tasks(tasks, num_tasks);

    return 0;
}