//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the size of the weather grid
#define GRID_SIZE 10

// Define the possible weather conditions
typedef enum _WeatherCondition
{
    SUNNY,
    CLOUDY,
    RAINY,
    STORMY
} WeatherCondition;

// Define the weather grid
WeatherCondition weather_grid[GRID_SIZE][GRID_SIZE];

// Define the probability of each weather condition
const float SUNNY_PROBABILITY = 0.5f;
const float CLOUDY_PROBABILITY = 0.3f;
const float RAINY_PROBABILITY = 0.1f;
const float STORMY_PROBABILITY = 0.1f;

// Function to initialize the weather grid
void initialize_weather_grid()
{
    for (int i = 0; i < GRID_SIZE; i++)
    {
        for (int j = 0; j < GRID_SIZE; j++)
        {
            float random_number = (float)rand() / RAND_MAX;

            if (random_number <= SUNNY_PROBABILITY)
            {
                weather_grid[i][j] = SUNNY;
            }
            else if (random_number <= SUNNY_PROBABILITY + CLOUDY_PROBABILITY)
            {
                weather_grid[i][j] = CLOUDY;
            }
            else if (random_number <= SUNNY_PROBABILITY + CLOUDY_PROBABILITY + RAINY_PROBABILITY)
            {
                weather_grid[i][j] = RAINY;
            }
            else
            {
                weather_grid[i][j] = STORMY;
            }
        }
    }
}

// Function to print the weather grid
void print_weather_grid()
{
    for (int i = 0; i < GRID_SIZE; i++)
    {
        for (int j = 0; j < GRID_SIZE; j++)
        {
            switch (weather_grid[i][j])
            {
            case SUNNY:
                printf("S ");
                break;
            case CLOUDY:
                printf("C ");
                break;
            case RAINY:
                printf("R ");
                break;
            case STORMY:
                printf("T ");
                break;
            default:
                printf("? ");
                break;
            }
        }
        printf("\n");
    }
}

// Main function
int main()
{
    // Initialize the random number generator
    srand(time(NULL));

    // Initialize the weather grid
    initialize_weather_grid();

    // Print the weather grid
    print_weather_grid();

    return 0;
}