//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

typedef struct {
    char name[50];
    int votes;
} Candidate;

typedef struct {
    char name[50];
    int voterID;
} Voter;

Candidate candidates[MAX_CANDIDATES];
Voter voters[MAX_VOTERS];
int numCandidates = 0;
int numVoters = 0;

void addCandidate(char name[50]) {
    if (numCandidates >= MAX_CANDIDATES) {
        printf("Error: Maximum number of candidates reached.\n");
        return;
    }
    strcpy(candidates[numCandidates].name, name);
    candidates[numCandidates].votes = 0;
    numCandidates++;
}

void addVoter(char name[50], int voterID) {
    if (numVoters >= MAX_VOTERS) {
        printf("Error: Maximum number of voters reached.\n");
        return;
    }
    strcpy(voters[numVoters].name, name);
    voters[numVoters].voterID = voterID;
    numVoters++;
}

void vote(int voterID, int candidateIndex) {
    if (voterID < 1 || voterID > numVoters || candidateIndex < 0 || candidateIndex >= numCandidates) {
        printf("Error: Invalid input.\n");
        return;
    }
    candidates[candidateIndex].votes++;
}

void displayResults() {
    printf("Election Results:\n");
    for (int i = 0; i < numCandidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    addCandidate("John Doe");
    addCandidate("Jane Doe");
    addVoter("Alice", 1);
    addVoter("Bob", 2);
    vote(1, 0);
    vote(2, 1);
    displayResults();
    return 0;
}