//GPT-4o-mini DATASET v1.0 Category: Temperature monitor ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h> // For sleep function
#include <time.h>   // For time function

#define MAX_READINGS 5
#define TEMP_WARNING_THRESHOLD 75.0 // Temperature in Fahrenheit 

void displayWelcomeMessage() {
    printf("********************************************\n");
    printf("          Welcome to Temperature Monitor     \n");
    printf("               Let's keep things cool!     \n");
    printf("********************************************\n");
}

void displayGoodbyeMessage() {
    printf("********************************************\n");
    printf("    Thank you for using Temperature Monitor! \n");
    printf("            Stay cool and safe!             \n");
    printf("********************************************\n");
}

float readTemperature() {
    // Simulate reading temperature from a sensor
    return (rand() % 100); // Simulating a temperature between 0 and 99
}

void checkTemperature(float temp) {
    if (temp > TEMP_WARNING_THRESHOLD) {
        printf("WARNING! High Temperature Detected: %.2f°F\n", temp);
        printf("Take necessary actions immediately!\n\n");
    } else {
        printf("Temperature is normal: %.2f°F\n\n", temp);
    }
}

void logTemperature(float temp) {
    FILE *logFile = fopen("temperature_log.txt", "a");
    if (logFile == NULL) {
        fprintf(stderr, "Error opening log file!\n");
        return;
    }
    
    time_t now = time(NULL);
    fprintf(logFile, "Temperature: %.2f°F - Time: %s", temp, ctime(&now));
    fclose(logFile);
    printf("Recorded temperature: %.2f°F in log file.\n", temp);
}

int main() {
    srand(time(NULL)); // Seed random number generator

    displayWelcomeMessage();
    
    for (int i = 0; i < MAX_READINGS; i++) {
        float currentTemp = readTemperature();

        printf("Current Reading %d: ", i + 1);
        checkTemperature(currentTemp);
        
        logTemperature(currentTemp);

        sleep(2); // Wait for 2 seconds before the next reading
    }

    displayGoodbyeMessage();
    return 0;
}