//Falcon-180B DATASET v1.0 Category: Ebook reader ; Style: configurable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_BOOKS 100
#define MAX_BOOK_NAME_LENGTH 100

typedef struct {
    char name[MAX_BOOK_NAME_LENGTH];
    int num_pages;
    int current_page;
} Book;

void add_book(Book* books, int num_books, char* name, int num_pages) {
    if (num_books >= MAX_BOOKS) {
        printf("Error: Too many books!\n");
        return;
    }

    strcpy(books[num_books].name, name);
    books[num_books].num_pages = num_pages;
    books[num_books].current_page = 1;

    num_books++;
}

void remove_book(Book* books, int num_books, int index) {
    if (index >= num_books) {
        printf("Error: Invalid book index!\n");
        return;
    }

    num_books--;

    if (index < num_books) {
        memmove(&books[index], &books[index + 1], sizeof(Book) * (num_books - index));
    }
}

void display_books(Book* books, int num_books) {
    for (int i = 0; i < num_books; i++) {
        printf("%d. %s\n", i + 1, books[i].name);
    }
}

void read_book(Book* books, int num_books, int index) {
    if (index >= num_books) {
        printf("Error: Invalid book index!\n");
        return;
    }

    printf("Reading %s...\n", books[index].name);
    for (int i = 1; i <= books[index].num_pages; i++) {
        printf("Page %d\n", i);
    }
}

int main() {
    Book books[MAX_BOOKS];
    int num_books = 0;

    add_book(books, num_books, "Harry Potter", 500);
    add_book(books, num_books, "The Lord of the Rings", 1000);
    add_book(books, num_books, "The Hobbit", 300);

    display_books(books, num_books);

    remove_book(books, num_books, 1);

    display_books(books, num_books);

    read_book(books, num_books, 0);

    return 0;
}