//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define a structure to store item information
struct item {
  char name[50];
  float price;
  int quantity;
};

// Define a function to calculate total cost
float calculateTotalCost(struct item items[], int numItems) {
  float totalCost = 0;
  for (int i = 0; i < numItems; i++) {
    totalCost += items[i].price * items[i].quantity;
  }
  return totalCost;
}

// Define a function to print the bill
void printBill(struct item items[], int numItems) {
  printf("-------------------------------------------------------------------\n");
  printf("                       C Cafe Billing System\n");
  printf("-------------------------------------------------------------------\n");
  printf("Item Name\t\t\tPrice\t\tQuantity\t\tTotal Cost\n");
  printf("-------------------------------------------------------------------\n");
  for (int i = 0; i < numItems; i++) {
    printf("%s\t\t\t%.2f\t\t%d\t\t%.2f\n", items[i].name, items[i].price, items[i].quantity, calculateTotalCost(items, numItems) * items[i].quantity);
  }
  printf("-------------------------------------------------------------------\n");
  printf("Total Cost: %.2f\n", calculateTotalCost(items, numItems));
  printf("-------------------------------------------------------------------\n");
  printf("Thank you for your visit to C Cafe!\n");
  printf("-------------------------------------------------------------------\n");
}

int main() {
  // Create an array of items
  struct item items[] = {
    {"Coffee", 5.0, 2},
    {"Tea", 3.0, 1},
    {"Juice", 4.0, 3},
    {"Smoothie", 6.0, 0}
  };

  // Calculate the total cost
  float totalCost = calculateTotalCost(items, 4);

  // Print the bill
  printBill(items, 4);

  return 0;
}